<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare(
			"INSERT INTO `antecedents` (`id_ente`,`id_patient`,`trait_habituel`,`asthme`,`diabete`,`allergie_medoc`,`habi_toxic`,`groupe_sg`,`group_rhesus`,`maladie_respiratoires`, `chirurgicaux`,
			`gyneco_obstetriques`,`familliaux`,`autres`)
			VALUES (NULL,:id_patient,:trait_habituel,:asthme,:diabete,:allergie_medoc,:habi_toxic,:groupe_sg,:group_rhesus,:maladie_respiratoires,:chirurgicaux,:gyneco_obstetriques,
			:familliaux,:autres)");

		$request->bindParam(':id_patient', $_POST["id_patient"]);
		$request->bindParam(':trait_habituel', $_POST["trait_habituel"]);
		$request->bindParam(':asthme', $_POST["asthme"]);
		$request->bindParam(':diabete', $_POST["diabete"]);
		$request->bindParam(':allergie_medoc', $_POST["allergie_medoc"]);
		$request->bindParam(':habi_toxic', $_POST["habi_toxic"]);
		$request->bindParam(':groupe_sg', $_POST["groupe_sg"]);
		$request->bindParam(':group_rhesus', $_POST["group_rhesus"]);
		$request->bindParam(':maladie_respiratoires', $_POST["maladie_respiratoires"]);
		$request->bindParam(':chirurgicaux', $_POST["chirurgicaux"]);
		$request->bindParam(':gyneco_obstetriques', $_POST["gyneco_obstetriques"]);
		$request->bindParam(':familliaux', $_POST["familliaux"]);
		$request->bindParam(':autres', $_POST["autres"]);
		$request->execute();
		$get = $pdo->prepare("SELECT * FROM antecedents WHERE id_ente=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $error) {
	retour_json(500, "Erreur " . $error->getCode() . ": " . $error->getMessage());
}
?>