<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$path_img = "";
		if (isset($_POST["path"]) && !is_null($_POST["path"]) && strlen($_POST["path"]) > 1) {

			$image = $_POST["path"];

			if (!file_exists(UPLOAD_PATH)) {
				mkdir(UPLOAD_PATH, 0777, true);
			}

			$img = rand() . "_" . time() . ".jpeg";

			$results["PATH"] = UPLOAD_PATH . "/" . $img;

			if (file_put_contents(UPLOAD_PATH . "/img_groupe/" . $img, base64_decode($image))) {
				$path_img = "./upload/img_groupe/" . $img;
				$results["UPLOAD"] = "Photo bien enregistre";

			} else {
				$path_img = "";
				$results["UPLOAD"] = "Photo par defaut bien enregistre apres (else 1)";
			}
		} else {
			$path_img = "";
			$results["UPLOAD"] = "Photo bien enregistre apres (else 2)";
		}

		$request = $pdo->prepare("INSERT INTO `groupe` (`id_groupe`, `id_admin`, `daty`, `nom`,
			`description`, `path`) VALUES (NULL, :id_admin, :daty, :nom, :description, :paths)");

		$request->bindParam(':paths', $path_img);
		$request->bindParam(':id_admin', $_POST["id_admin"]);
		$request->bindParam(':daty', $_POST["daty"]);
		$request->bindParam(':nom', $_POST["nom"]);
		$request->bindParam(':description', $_POST["description"]);

		$request->execute();
		$get = $pdo->prepare("SELECT * FROM groupe WHERE id_groupe=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();

		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $error) {
	retour_json(500, "Erreur " . $error->getCode() . ": " . $error->getMessage());
}
?>