<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$path_img = "";
		if (isset($_POST["path_logo"]) && strlen($_POST["path_logo"]) > 1) {
			$image = $_POST["path_logo"];
			if (!file_exists(UPLOAD_PATH)) {
				mkdir(UPLOAD_PATH, 0777, true);
			}
			$img = rand() . "_" . time() . ".jpeg";
			$results["PATH"] = UPLOAD_PATH . "/" . $img;
			if (file_put_contents(UPLOAD_PATH . "/img_logo_hopital/" . $img, base64_decode($image))) {
				$path_img = "upload/img_logo_hopital/" . $img;
				$results["UPLOAD"] = "Photo bien enregistre";
			} else {
				$path_img = "assets/images/logo-medoc-theme.png";
				$results["UPLOAD"] = "Photo par defaut bien enregistre apres (else 1)";
			}
		} else {
			$path_img = "assets/images/logo-medoc-theme.png";
			$results["UPLOAD"] = "Photo bien enregistre apres (else 2)";
		}
		$requete = $pdo->prepare("INSERT INTO `lieutravail` (`id_lieu_w`, `nom_lieu`, `adresse`, `path_logo`) VALUES
				(NULL, :nom_lieu, :adresse, :path_logo)");

		$requete->bindParam(':path_logo', $path_img);
		$requete->bindParam(':nom_lieu', $_POST["nom_lieu"]);
		$requete->bindParam(':adresse', $_POST["adresse"]);
		$requete->execute();

		$get = $pdo->prepare("SELECT * FROM lieutravail WHERE id_lieu_w=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>