<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$path_img = "";
		if (isset($_POST["images"]) && !is_null($_POST["images"]) && strlen($_POST["images"]) > 1) {

			$image = $_POST["images"];

			if (!file_exists(UPLOAD_PATH)) {
				mkdir(UPLOAD_PATH, 0777, true);
			}

			$img = rand() . "_" . time() . ".jpeg";

			$results["PATH"] = UPLOAD_PATH . "/" . $img;

			if (file_put_contents(UPLOAD_PATH . "/img_maladie/" . $img, base64_decode($image))) {
				$path_img = "./upload/img_maladie/" . $img;
				$results["UPLOAD"] = "Photo bien enregistre";

			} else {
				$results["UPLOAD"] = "photo vide";
			}
		} else {
			$results["UPLOAD"] = "photo vide";
		}

		$request = $pdo->prepare("INSERT INTO `maladie` (`idMaladie`, `nom`, `content`, `image`)VALUES(NULL, :nom, :content, :images);");
		$request->bindParam(':nom', $_POST["nom"]);
		$request->bindParam(':content', $_POST["content"]);
		$request->bindParam(':images', $path_img);
		$request->execute();

		$get = $pdo->prepare("SELECT * FROM maladie WHERE idMaladie=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>