<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare(
			"INSERT INTO `mutuelle` (`id`,`nom`,`tel`,`mdp`,`adresse`,`email`,`description`,`sommeCotisation`,`sommeCaisse`)
			VALUES (NULL,:nom,:tel,:mdp,:adresse,:email,:description_mutuelle,:sommeCotisation,:sommeCaisse);");

		$request->bindParam(':nom', $_POST["nom"]);
		$request->bindParam(':tel', $_POST["tel"]);
		$request->bindParam(':mdp', password_hash($_POST["mdp"], PASSWORD_DEFAULT));
		$request->bindParam(':adresse', $_POST["adresse"]);
		$request->bindParam(':email', $_POST["email"]);
		$request->bindParam(':description_mutuelle', $_POST["description_mutuelle"]);
		$request->bindParam(':sommeCotisation', $_POST["sommeCotisation"]);
		$request->bindParam(':sommeCaisse', $_POST["sommeCaisse"]);
		$request->execute();

		$get = $pdo->prepare("SELECT * FROM mutuelle WHERE id=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>