<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("INSERT INTO `mutuelle_suivi_cotisation` (`id_membre`,
				`id_mutuelle`, `id_mois`, `annee`, `dateInsert`)
				VALUES (:id_membre, :id_mutuelle, :id_mois, :annee, :dateInsert);");

		$request->bindParam(':id_membre', $_POST["id_membre"]);
		$request->bindParam(':id_mutuelle', $_POST["id_mutuelle"]);
		$request->bindParam(':id_mois', $_POST["id_mois"]);
		$request->bindParam(':annee', $_POST["annee"]);
		$request->bindParam(':dateInsert', $_POST["dateInsert"]);
		$request->execute();

		$get = $pdo->prepare("SELECT * FROM mutuelle_suivi_cotisation WHERE `id_membre`=:id_membre AND `id_mutuelle`=:id_mutuelle AND `id_mois`=:id_mois");
		$get->bindParam(':id_membre', $_POST["id_membre"]);
		$get->bindParam(':id_mutuelle', $_POST["id_mutuelle"]);
		$get->bindParam(':id_mois', $_POST["id_mois"]);
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success ", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>