<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$insert = $pdo->prepare(
			"INSERT INTO `planification_relation_produit`(`id_planification`,`id_produit`,`quantite`)VALUES(:id_planification,:id_produit,:quantite);");
		$insert->bindParam(':id_planification', $_POST["id_planification"]);
		$insert->bindParam(':id_produit', $_POST["id_produit"]);
		$insert->bindParam(':quantite', $_POST["quantite"]);
		$insert->execute();

		$get = $pdo->prepare("SELECT * FROM planification_relation_produit WHERE id_planification=:id_planification AND id_produit=:id_produit AND quantite=:quantite  LIMIT 1");
		$get->bindParam(':id_planification', $_POST["id_planification"]);
		$get->bindParam(':id_produit', $_POST["id_produit"]);
		$get->bindParam(':quantite', $_POST["quantite"]);
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>