<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$insert = $pdo->prepare("INSERT INTO `salle_des_service`(`id_departement`,`id_salle`) VALUES(:id_departement,:id_salle);");
		$insert->bindParam(':id_departement', $_POST["id_departement"]);
		$insert->bindParam(':id_salle', $_POST["id_salle"]);
		$insert->execute();

		$get = $pdo->prepare("SELECT * FROM salle_des_service WHERE id_departement=:id_departement AND id_salle=:id_salle LIMIT 1");
		$get->bindParam(':id_departement', $_POST["id_departement"]);
		$get->bindParam(':id_salle', $_POST["id_salle"]);
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>