<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$insert = $pdo->prepare("INSERT INTO `service_lieu_travail`(`id_lieu`,`id_departement`) VALUES(:id_lieu,:id_departement);");
		$insert->bindParam(':id_lieu', $_POST["id_lieu"]);
		$insert->bindParam(':id_departement', $_POST["id_departement"]);
		$insert->execute();

		$get = $pdo->prepare("SELECT * FROM service_lieu_travail WHERE id_lieu=:id_lieu AND id_departement=:id_departement LIMIT 1");
		$get->bindParam(':id_lieu', $_POST["id_lieu"]);
		$get->bindParam(':id_departement', $_POST["id_departement"]);
		$get->execute();
		$result = $get->fetch();
		retour_json(200, "bien success", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>