<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$requestDoctor = $pdo->prepare("SELECT * FROM medecin WHERE cnm = :cnm");
		$requestDoctor->bindParam(':cnm', $_POST["cnm"]);
		$requestDoctor->execute();
		$resultDoctor = $requestDoctor->fetchAll();

		$requestCnm = $pdo->prepare("SELECT * FROM cnm WHERE num_cnm = :cnm");
		$requestCnm->bindParam(':cnm', $_POST["cnm"]);
		$requestCnm->execute();
		$resultCnm = $requestCnm->fetchAll();

		if (count($resultDoctor) <= 0 && count($resultCnm) > 0) {
			$request = $pdo->prepare("INSERT INTO `medecin` (`id_medecin`,
						`id_type`, `id_lieu_trv`, `nom`, `prenom`, `email`, `tel`, `mdp`,
						`cnm`, `path_img`, `enligne`, `time_enligne`, `medecin_specialiste`, `bloquer`)
						VALUES (NULL, :id_type, :id_lieu_trv, :nom, :prenom, :email, :tel, :mdp, :cnm, :path_img,
						:enligne, :time_enligne, :medecin_specialiste, :bloquer);");

			$request->bindParam(':id_type', $_POST["idDoctorType"]);
			$request->bindParam(':id_lieu_trv', $_POST["idPlaceWork"]);
			$request->bindParam(':nom', $_POST["name"]);
			$request->bindParam(':prenom', $_POST["firstName"]);
			$request->bindParam(':email', $_POST["email"]);
			$request->bindParam(':tel', $_POST["phoneNumber"]);
			$request->bindParam(':mdp', password_hash($_POST["password"], PASSWORD_DEFAULT));
			$request->bindParam(':cnm', $_POST["cnm"]);
			$request->bindParam(':medecin_specialiste', $_POST["isSpecialist"]);
			$request->bindParam(':bloquer', $_POST["blocked"]);
			$request->bindParam(':time_enligne', $_POST["numberTimbeOnline"]);
			$request->bindParam(':enligne', $_POST["online"]);
			$request->bindParam(':path_img', $_POST["picture"]);

			$result = $request->execute();
			retour_json(200, "bien success ", $result);

		} else {
			retour_json(200, "deja pris ou cnm n'existe pas", []);
		}
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>