<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$insert = $pdo->prepare("INSERT INTO `suivi_grossesse`(`id`,`trimestre`,`date_suivi`,`date_derniere_regle`,`semaine_amenorrhee`,`date_prevu_accouchement`,`date_debut_grossesse`,`id_prenatale`)
                        VALUES(NULL,:trimestre,:date_suivi,:date_derniere_regle,:semaine_amenorrhee,:date_prevu_accouchement,:date_debut_grossesse,:id_prenatale);");

		$dateGrosse = $_POST["date_debut_grossesse"] == "null" ? NULL : $_POST["date_debut_grossesse"];
		$dateRegle = $_POST["date_derniere_regle"] == "null" ? NULL : $_POST["date_derniere_regle"];
		$dateAccouchement = $_POST["date_prevu_accouchement"] == "null" ? NULL : $_POST["date_prevu_accouchement"];

		$insert->bindParam(':trimestre', $_POST["trimestre"]);
		$insert->bindParam(':date_suivi', $_POST["date_suivi"]);
		$insert->bindParam(':date_derniere_regle', $dateRegle);
		$insert->bindParam(':semaine_amenorrhee', $_POST["semaine_amenorrhee"]);
		$insert->bindParam(':date_prevu_accouchement', $dateAccouchement);
		$insert->bindParam(':date_debut_grossesse', $dateGrosse);
		$insert->bindParam(':id_prenatale', $_POST["id_prenatale"]);
		$insert->execute();

		$get = $pdo->prepare("SELECT * FROM suivi_grossesse WHERE id=LAST_INSERT_ID()");
		$get->execute();
		$result = $get->fetch();

		retour_json(200, "bien success", $result);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>