<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	if (!empty($_POST['username']) && !empty($_POST['password'])) {

		$requestDoctor = $pdo->prepare("SELECT * FROM medecin WHERE cnm = :cnm LIMIT 1");
		$requestDoctor->bindParam(':cnm', $_POST["username"]);
		$requestDoctor->execute();
		$resultDoctor = $requestDoctor->fetchAll();

		if (count($resultDoctor) > 0) {
			if (password_verify($_POST["password"], $resultDoctor[0]['mdp'])) {
				if (strcmp($resultDoctor[0]['medecin_specialiste'], "OUI") == 0) {
					$authentication = new AuthenticationImplement();
					$token = $authentication->generateToken($resultDoctor[0]);
					$resultDoctor["token"] = $token;
					retour_json(200, "medecin", $resultDoctor);
				} else {
					retour_json(202, "medecin non specialist", []);
				}

			} else {
				retour_json(202, "Mot de passe incorrect.", []);
			}

		} else {
			retour_json(202, "cnm ou mot de passe vide", []);
		}

	} else {
		retour_json(202, "cnm ou mot de passe vide.", []);
	}

} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>