<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	if (!empty($_POST['email']) && !empty($_POST['password'])) {

		$requestMutualPersonal = $pdo->prepare("SELECT * FROM mutuelle_personnel WHERE email = :email LIMIT 1");
		$requestMutualPersonal->bindParam(':email', $_POST["email"]);
		$requestMutualPersonal->execute();
		$resultMutualPersonal = $requestMutualPersonal->fetchAll();

		if (count($resultMutualPersonal) > 0) {
			if (password_verify($_POST["password"], $resultMutualPersonal[0]['mdp'])) {
				$requestMutualRelationPersonal = $pdo->prepare("SELECT * FROM mutuelle_relation_personnel WHERE id_personnel = :id_personnel AND id_mutuelle = :id_mutuelle");
				$requestMutualRelationPersonal->bindParam(':id_personnel', $resultMutualPersonal[0]["id_mutuelle_personnel"]);
				$requestMutualRelationPersonal->bindParam(':id_mutuelle', $_POST["idMutual"]);
				$requestMutualRelationPersonal->execute();
				$resultMutualRelationPersonal = $requestMutualRelationPersonal->fetchAll();
				if (count($resultMutualRelationPersonal) > 0) {
					$authentication = new AuthenticationImplement();
					$token = $authentication->generateToken($resultMutualPersonal[0]);
					$resultMutualPersonal["token"] = $token;
					retour_json(200, "mutuelle_personnel", $resultMutualPersonal);
				} else {
					retour_json(202, "email ou mot de passe vide 1", []);
				}
			} else {
				retour_json(202, "Mot de passe incorrect.", []);
			}

		} else {
			retour_json(202, "email ou mot de passe vide 2", []);
		}

	} else {
		retour_json(202, "email ou mot de passe vide 3.", []);
	}

} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>