<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	if (!empty($_POST['username']) && !empty($_POST['password'])) {

		$requestParamedic = $pdo->prepare("SELECT * FROM medecin WHERE nom = :nom AND mdp = :mdp LIMIT 1");
		$requestParamedic->bindParam(':nom', $_POST["username"]);
		$requestParamedic->bindParam(':mdp', $_POST["password"]);
		$requestParamedic->execute();
		$resultParamedic = $requestParamedic->fetchAll();
		if (count($resultParamedic) > 0) {
			$authentication = new AuthenticationImplement();
			$token = $authentication->generateToken($resultParamedic[0]);
			$resultParamedic["token"] = $token;
			retour_json(200, "aidesoignant", $resultParamedic);
		} else {
			retour_json(202, "nom ou code d'acces incorrect", []);
		}
	} else {
		retour_json(202, "nom ou code d'acces vide.", []);
	}

} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>