<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	if (!empty($_POST['name']) && !empty($_POST['password'])) {

		$requestPatient = $pdo->prepare("SELECT * FROM patient WHERE nom = :nom AND mdp = :mdp LIMIT 1");
		$requestPatient->bindParam(':nom', $_POST["name"]);
		$requestPatient->bindParam(':mdp', $_POST["password"]);
		$requestPatient->execute();
		$resultPatient = $requestPatient->fetchAll();

		if (count($resultPatient) > 0) {
			$authentication = new AuthenticationImplement();
			$token = $authentication->generateToken($resultPatient[0]);
			$resultPatient["token"] = $token;
			retour_json(200, "patient connecter", $resultPatient);
		} else {
			retour_json(202, "nom ou mot de passe incorrect", []);
		}
	} else {
		retour_json(202, "nom ou mot de passe vide.", []);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>