<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	if (!empty($_POST['email']) && !empty($_POST['password'])) {

		$requestDoctor = $pdo->prepare("SELECT * FROM medecin WHERE email = :email LIMIT 1");
		$requestDoctor->bindParam(':email', $_POST["email"]);
		$requestDoctor->execute();
		$resultDoctor = $requestDoctor->fetchAll();

		if (count($resultDoctor) > 0) {
			if (password_verify($_POST["password"], $resultDoctor[0]['mdp'])) {
				$requestDoctorType = $pdo->prepare("SELECT * FROM medecin_type WHERE id_med_type = :id_med_type LIMIT 1");
				$requestDoctorType->bindParam(':id_med_type', $resultDoctor[0]["id_type"]);
				$requestDoctorType->execute();
				$resultDoctorType = $requestDoctorType->fetchAll();

				if (strcasecmp($resultDoctorType[0]["type_med"], "Radiologue") == 0) {
					$authentication = new AuthenticationImplement();
					$token = $authentication->generateToken($resultDoctor[0]);
					$resultDoctor["token"] = $token;
					retour_json(200, "radiologue", $resultDoctor);
				} else {
					retour_json(202, "pas radiologue", []);
				}

			} else {
				retour_json(202, "Mot de passe incorrect.", []);
			}

		} else {
			retour_json(202, "email ou mot de passe vide", []);
		}

	} else {
		retour_json(202, "email ou mot de passe vide.", []);
	}

} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}

?>