<?php
include_once '../../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("SELECT* FROM patient WHERE id_medTraitant = :id_medTraitant ORDER BY id_patient");
		$request->bindParam(':id_medTraitant', $_GET["id_medecin"]);
		$request->execute();
		$patients = $request->fetchAll();
		$results["count"] = count($patients);
		$results["patient"] = $patients;
		retour_json(200, "patient", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>