<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `acte_medical` SET `nom_acte` = :nom_acte,
		 	`prix` = :prix WHERE `idActe` = :idActe");
		$request->bindParam(':idActe', $_POST["idActe"]);
		$request->bindParam(':nom_acte', $_POST["nom_acte"]);
		$request->bindParam(':prix', $_POST["prix"]);
		$result = $request->execute();
		$results["id"] = $_POST["idActe"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>