<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `analyse` SET `idAnalyseType` = :idAnalyseType,
			`MedecinAuLaboratoir` = :MedecinAuLaboratoir, `idDesignation` = :idDesignation,
			`renseignement_clicnique` = :renseignement_clicnique WHERE `id_analyse` = :id_analyse");

		$idDesignation = $_POST["idDesignation"] == "null" ? NULL : $_POST["idDesignation"];

		$request->bindParam(':id_analyse', $_POST["id_analyse"]);
		$request->bindParam(':idAnalyseType', $_POST["idAnalyseType"]);
		$request->bindParam(':idDesignation', $idDesignation);
		$request->bindParam(':MedecinAuLaboratoir', $_POST["MedecinAuLaboratoir"]);
		$request->bindParam(':renseignement_clicnique', $_POST["renseignement_clicnique"]);
		$result = $request->execute();
		$results["id"] = $_POST["id_analyse"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>