<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `arret_travail` SET `motif` = :motif,
		 	`duree` = :duree, `dateDebut` = :dateDebut,
		  	`dateFin` = :dateFin WHERE `idArret` = :idArret");

		$request->bindParam(':idArret', $_POST["idArret"]);
		$request->bindParam(':motif', $_POST["motif"]);
		$request->bindParam(':duree', $_POST["duree"]);
		$request->bindParam(':dateDebut', $_POST["dateDebut"]);
		$request->bindParam(':dateFin', $_POST["dateFin"]);
		$result = $request->execute();
		$results["id"] = $_POST["idArret"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>