<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `bloc_operatoire` SET `id_nature`=:id_nature,`id_anesthesie_type`=:id_anesthesie_type,
            `id_type_intervention`=:id_type_intervention,`status`=:status WHERE `id` = :id");

		$idAnesthesie = $_POST["id_anesthesie_type"] == "null" ? NULL : $_POST["id_anesthesie_type"];
		$idNature = $_POST["id_nature"] == "null" ? NULL : $_POST["id_nature"];
		$idType = $_POST["id_type_intervention"] == "null" ? NULL : $_POST["id_type_intervention"];

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':id_nature', $idNature);
		$request->bindParam(':id_anesthesie_type', $idAnesthesie);
		$request->bindParam(':id_type_intervention', $idType);
		$request->bindParam(':status', $_POST["status"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>
