<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `communication_sensibilisation` SET `programme`=:programme,`theme`=:theme,
            `nombre_homme`=:nombre_homme,`nombre_femme`=:nombre_femme WHERE `id` = :id");

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':programme', $_POST["programme"]);
		$request->bindParam(':theme', $_POST["theme"]);
		$request->bindParam(':nombre_homme', $_POST["nombre_homme"]);
		$request->bindParam(':nombre_femme', $_POST["nombre_femme"]);
		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>