<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `creni` SET `oedeme`=:oedeme,`rechute`=:rechute,
            `transfere`=:transfere,`status_sortie`=:status_sortie,`poids_taille`=:poids_taille,`perimetre_brachial`=:perimetre_brachial WHERE `id_creni`=:id_creni");

		$request->bindParam(':id_creni', $_POST["id_creni"]);
		$request->bindParam(':oedeme', $_POST["oedeme"]);
		$request->bindParam(':rechute', $_POST["rechute"]);
		$request->bindParam(':transfere', $_POST["transfere"]);
		$request->bindParam(':status_sortie', $_POST["status_sortie"]);
		$request->bindParam(':poids_taille', $_POST["poids_taille"]);
		$request->bindParam(':perimetre_brachial', $_POST["perimetre_brachial"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_creni"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>