<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `droits` SET `id_medecin` = :id_medecin, `autorisLire` = :autorisLire,
			`autorisCreerEdit` = :autorisCreerEdit, `autorisDelete` = :autorisDelete, `eltDoc` = :eltDoc
			WHERE `id_droit` = :id_droit");

		$request->bindParam(':id_droit', $_POST["id_droit"]);
		$request->bindParam(':id_medecin', $_POST["id_medecin"]);
		$request->bindParam(':autorisLire', $_POST["autorisLire"]);
		$request->bindParam(':autorisCreerEdit', $_POST["autorisCreerEdit"]);
		$request->bindParam(':autorisDelete', $_POST["autorisDelete"]);
		$request->bindParam(':eltDoc', $_POST["eltDoc"]);
		$result = $request->execute();
		$results["id"] = $_POST["id_droit"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $error) {
	retour_json(500, "Erreur " . $error->getCode() . ": " . $error->getMessage());
}
?>