<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `facture` SET `part_mutuelle` = :part_mutuelle,
			 `part_patient` = :part_patient WHERE `id` = :id");

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':part_mutuelle', $_POST["part_mutuelle"]);
		$request->bindParam(':part_patient', $_POST["part_patient"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>