<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `groupe_commentaire` SET `coms` = :coms
			WHERE `id_commentaire` = :id_commentaire");

		$request->bindParam(':id_commentaire', $_POST["id_commentaire"]);
		$request->bindParam(':coms', $_POST["coms"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_commentaire"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>