<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `hospitalisation` SET `id_salle`=:id_salle,`id_mode_sorti`=:id_mode_sorti,`motif`=:motif,
            `date_heure_sortie`=:date_heure_sortie,`transfusion`=:transfusion,`prise_charge_social`=:prise_charge_social,
            `code_diagnostic`=:code_diagnostic WHERE `id`=:id");

		$idSalle = $_POST["id_salle"] == "null" ? NULL : $_POST["id_salle"];
		$idMode = $_POST["id_mode_sorti"] == "null" ? NULL : $_POST["id_mode_sorti"];
		$dateSortie = $_POST["date_heure_sortie"] == "null" ? NULL : $_POST["date_heure_sortie"];

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':id_salle', $idSalle);
		$request->bindParam(':id_mode_sorti', $idMode);
		$request->bindParam(':motif', $_POST["motif"]);
		$request->bindParam(':date_heure_sortie', $dateSortie);
		$request->bindParam(':transfusion', $_POST["transfusion"]);
		$request->bindParam(':prise_charge_social', $_POST["prise_charge_social"]);
		$request->bindParam(':code_diagnostic', $_POST["code_diagnostic"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>