<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$isVerify = password_verify($_POST["ancien_mdp"], $_POST["mdp"]);
		if ($isVerify) {
			$newPassword = password_hash($_POST["nouveau_mdp"], PASSWORD_DEFAULT);
			$requete = $pdo->prepare("UPDATE `medecin` SET `mdp` = :nouveau_mdp WHERE `id_medecin` = :id_medecin");

			$requete->bindParam(':id_medecin', $_POST["id_medecin"]);
			$requete->bindParam(':nouveau_mdp', $newPassword);
			$result = $requete->execute();

			retour_json(200, "Succès", true);
		} else {
			return retour_json(200, "Succès", false);
		}
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>