<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `membre` SET `nekena` = :nekena WHERE `id_membre` = :id_membre");

		$request->bindParam(':id_membre', $_POST["id_membre"]);
		$request->bindParam(':nekena', $_POST["nekena"]);
		$result = $request->execute();
		$results["id"] = $_POST["id_membre"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>