<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `mutuelle_paiement_personnel` SET `id_personnel` = :id_personnel,
			`id_membre` = :id_membre, `taux` = :taux, `motif` = :motif WHERE `id_paie` = :id_paie");

		$request->bindParam(':id_paie', $_POST["id_paie"]);
		$request->bindParam(':id_personnel', $_POST["id_personnel"]);
		$request->bindParam(':id_membre', $_POST["id_membre"]);
		$request->bindParam(':taux', $_POST["taux"]);
		$request->bindParam(':motif', $_POST["motif"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_paie"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>