<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `mutuelle_personnel` SET `nom` = :nom,
			`prenom` = :prenom, `email` = :email, `tel` = :tel, `sommeCompte` = :sommeCompte,
			`deleted` = :deleted WHERE `id_mutuelle_personnel` = :id_mutuelle_personnel");

		$request->bindParam(':id_mutuelle_personnel', $_POST["id_mutuelle_personnel"]);
		$request->bindParam(':nom', $_POST["nom"]);
		$request->bindParam(':prenom', $_POST["prenom"]);
		$request->bindParam(':email', $_POST["email"]);
		$request->bindParam(':tel', $_POST["tel"]);
		$request->bindParam(':sommeCompte', $_POST["sommeCompte"]);
		$request->bindParam(':deleted', $_POST["deleted"]);
		$result = $request->execute();
		$results["id"] = $_POST["id_mutuelle_personnel"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>