<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `mutuelle_relation_membre` SET `prix_en_charge` = :prix_en_charge,
			`idPat` = :idPat, `restePayer` = :restePayer WHERE `id` = :id");

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':prix_en_charge', $_POST["prix_en_charge"]);
		$request->bindParam(':idPat', $_POST["idPat"]);
		$request->bindParam(':restePayer', $_POST["restePayer"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>