<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `planification_familiale` SET `id_methode`=:id_methode,`id_strategie`=:id_strategie,
            `effet_secondaire`=:effet_secondaire,`cas_referer`=:cas_referer,`observation`=:observation WHERE `id`=:id");

		$idStrategie = $_POST["id_strategie"] == "null" ? NULL : $_POST["id_strategie"];
		$idMethode = $_POST["id_methode"] == "null" ? NULL : $_POST["id_methode"];

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':id_methode', $idMethode);
		$request->bindParam(':id_strategie', $idStrategie);
		$request->bindParam(':effet_secondaire', $_POST["effet_secondaire"]);
		$request->bindParam(':cas_referer', $_POST["cas_referer"]);
		$request->bindParam(':observation', $_POST["observation"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>