<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$requete = $pdo->prepare("UPDATE `reference` SET `idMedecinDestinateur` = :idMedecinDestinateur,
			 `idService` = :idService, `renseignement_clinique` = :renseignement_clinique,
		 	 `dateTransfere` = :dateTransfere WHERE `idReferecne` = :idReferecne");
		$idDestinateur = $_POST["idMedecinDestinateur"] == "null" ? NULL : $_POST["idMedecinDestinateur"];

		$requete->bindParam(':idMedecinDestinateur', $idDestinateur);
		$requete->bindParam(':idService', $_POST["idService"]);
		$requete->bindParam(':renseignement_clinique', $_POST["renseignement_clinique"]);
		$requete->bindParam(':dateTransfere', $_POST["dateTransfere"]);
		$requete->bindParam(':idReferecne', $_POST["idReferecne"]);
		$result = $requete->execute();
		$results["id"] = $_POST["idReferecne"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $error) {
	retour_json(500, "Erreur " . $error->getCode() . ": " . $error->getMessage());
}
?>