<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `refrigerateur` SET `temperature_max`=:temperature_max,`temperature_min`=:temperature_min,
            `nombre_alarme_negative`=:nombre_alarme_negative,`nombre_alarme_positive`=:nombre_alarme_positive,`fonctionnel`=:fonctionnel
            WHERE `id_refrigerateur`=:id_refrigerateur");

		$request->bindParam(':id_refrigerateur', $_POST["id_refrigerateur"]);
		$request->bindParam(':temperature_max', $_POST["temperature_max"]);
		$request->bindParam(':temperature_min', $_POST["temperature_min"]);
		$request->bindParam(':nombre_alarme_negative', $_POST["nombre_alarme_negative"]);
		$request->bindParam(':nombre_alarme_positive', $_POST["nombre_alarme_positive"]);
		$request->bindParam(':fonctionnel', $_POST["fonctionnel"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_refrigerateur"];
		retour_json(200, "Succès", $results);

	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>
