<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `signesphysiques` SET `idDossier` = :idDossier,
		 `idPrescripteur` = :idPrescripteur, `cardio_vasculaire` = :cardio_vasculaire,
		  `respiratoire` = :respiratoire, `digestif` = :digestif,`urinaire` = :urinaire,
		   `neurologique` = :neurologique, `autre` = :autre, `diagnostique_et_hypothese` = :diagnostique_et_hypothese,
		 `conclusion` = :conclusion WHERE `id_signephysique` = :id_signephysique");

		$request->bindParam(':id_signephysique', $_POST["id_signephysique"]);
		$request->bindParam(':idDossier', $_POST["idDossier"]);
		$request->bindParam(':idPrescripteur', $_POST["idPrescripteur"]);
		$request->bindParam(':cardio_vasculaire', $_POST["cardio_vasculaire"]);
		$request->bindParam(':respiratoire', $_POST["respiratoire"]);
		$request->bindParam(':digestif', $_POST["digestif"]);
		$request->bindParam(':urinaire', $_POST["urinaire"]);
		$request->bindParam(':neurologique', $_POST["neurologique"]);
		$request->bindParam(':autre', $_POST["autre"]);
		$request->bindParam(':diagnostique_et_hypothese', $_POST["diagnostique_et_hypothese"]);
		$request->bindParam(':conclusion', $_POST["conclusion"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_signephysique"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>