<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `synthese_activite` SET `incoherent_donnee_autre_probleme`=:incoherent_donnee_autre_probleme,
            `recommandation`=:recommandation WHERE `id`=:id");

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':incoherent_donnee_autre_probleme', $_POST["incoherent_donnee_autre_probleme"]);
		$request->bindParam(':recommandation', $_POST["recommandation"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>