<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `urgence` SET `id_urgence_mode_sortie`=:id_urgence_mode_sortie,
            `id_patient`=:id_patient,`id_urgence_motif`=:id_urgence_motif,`refere`=:refere,`auto_refere`=:auto_refere WHERE `id_urgence`=:id_urgence");

		$idMode = $_POST["id_urgence_mode_sortie"] == "null" ? NULL : $_POST["id_urgence_mode_sortie"];
		$idPatient = $_POST["id_patient"] == "null" ? NULL : $_POST["id_patient"];
		$idMotif = $_POST["id_urgence_motif"] == "null" ? NULL : $_POST["id_urgence_motif"];

		$request->bindParam(':id_urgence', $_POST["id_urgence"]);
		$request->bindParam(':id_urgence_mode_sortie', $idMode);
		$request->bindParam(':id_patient', $idPatient);
		$request->bindParam(':id_urgence_motif', $idMotif);
		$request->bindParam(':refere', $_POST["refere"]);
		$request->bindParam(':auto_refere', $_POST["auto_refere"]);

		$result = $request->execute();
		$results["id"] = $_POST["id_urgence"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>