<?php
include_once '../../../core/initialize.php';
require SITE_ROOT . '/authentication/authentication_implement.php';

try {
	$authentication = new AuthenticationImplement();
	if (isset($_POST["token"]) && $authentication->verifyToken($_POST["token"])) {
		$request = $pdo->prepare("UPDATE `vaccination` SET `id_type`=:id_type,
            `id_strategie`=:id_strategie,`dose`=:dose,`id_mapi`=:id_mapi,`cas_mapi_notifie`=:cas_mapi_notifie,
            `cas_mapi_investigues`=:cas_mapi_investigues WHERE `id`=:id");

		$idStrategie = $_POST["id_strategie"] == "null" ? NULL : $_POST["id_strategie"];
		$idMapi = $_POST["id_mapi"] == "null" ? NULL : $_POST["id_mapi"];

		$request->bindParam(':id', $_POST["id"]);
		$request->bindParam(':id_type', $_POST["id_type"]);
		$request->bindParam(':id_strategie', $idStrategie);
		$request->bindParam(':dose', $_POST["dose"]);
		$request->bindParam(':id_mapi', $idMapi);
		$request->bindParam(':cas_mapi_notifie', $_POST["cas_mapi_notifie"]);
		$request->bindParam(':cas_mapi_investigues', $_POST["cas_mapi_investigues"]);

		$result = $request->execute();
		$results["id"] = $_POST["id"];
		retour_json(200, "Succès", $results);
	} else {
		retour_json(401, "Vous n'avez pas d'accès à cette ressource", NULL);
	}
} catch (Exception $e) {
	retour_json(500, "Erreur " . $e->getCode() . ": " . $e->getMessage());
}
?>