

<?php
require SITE_ROOT . '/vendor/autoload.php';
include_once 'authentication_interface.php';

use Dotenv\Dotenv;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$dotenv = Dotenv::createImmutable(SITE_ROOT . '/');
$dotenv->load();
$secretKey = $_ENV['SECRET_KEY'];

class AuthenticationImplement implements AuthenticationInterface {
	public function generateToken($playload) {
		global $secretKey;
		$token = JWT::encode($playload, $secretKey, 'HS256');
		return $token;
	}

	public function verifyToken($token) {
		global $secretKey;
		try {
			$decoded = JWT::decode($token, new Key($secretKey, 'HS256'));
			return true;
		} catch (Exception $e) {
			return false;
		}
	}
}

?>