<?php
require_once 'vendor/autoload.php';
use Dotenv\Dotenv;

header('Content-type: text/plain; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Content-Type: Application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Methods: UPDATE');
header('Access-Control-Allow-Methods: DELETE');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

$dbHost = $_ENV['DB_HOST'];
$dbName = $_ENV['DB_NAME'];
$dbPort = $_ENV['DB_PORT'];
$dbUser = $_ENV['DB_USER'];
$dbPassord = $_ENV["DB_PASSWORD"];

try {
	$pdo = new PDO('mysql:host=' . $dbHost . ';port=' . $dbPort . ';dbname=' . $dbName . ';charset=utf8;', $dbUser, $dbPassord);
	$pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
	$pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);
	$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	define('APP_NAME', 'MEDOC');
} catch (Exception $e) {
	retour_json(false, "Il y a un Probleme de connexion avec la base de donnee");
}

function retour_json($status, $msg, $result = NULL) {
	$retour["status"] = $status;
	$retour["message"] = $msg;
	$retour["results"] = $result;
	echo json_encode($retour);
}
?>